@echo off
chcp 65001 > nul
cls
setlocal enabledelayedexpansion

:: Prüfe auf Admin-Rechte
NET SESSION >nul 2>&1
IF %ERRORLEVEL% NEQ 0 (
    echo ERROR: Dieses Skript muss als Administrator ausgeführt werden!
    pause
    exit /b 1
)

:: Logdatei erstellen
echo Windows Update Reset Log > "%~dp0update_log.txt"
echo --------------------------------------------------- >> "%~dp0update_log.txt"
echo %date% %time% >> "%~dp0update_log.txt"
echo --------------------------------------------------- >> "%~dp0update_log.txt"
echo . >> "%~dp0update_log.txt"

:: Funktion für duale Ausgabe
set "log=call :log_write"
goto :main

:log_write
if "%*"=="." (
    echo. >> "%~dp0update_log.txt"
    echo.
) else (
    echo %* >> "%~dp0update_log.txt"
    echo %*
)
exit /b

:main
%log% ---------------------------------------------------
%log% Windows Update zurücksetzen und Dienste neustarten
%log% ---------------------------------------------------
%log% .
%log% Dieses Skript wird folgende Aktionen ausführen:
%log% 1. Windows Update-Dienste stoppen
%log% 2. Update-Cache-Ordner bereinigen
%log% 3. Dienste neu starten
%log% 4. Optional: PC neustarten
%log% .
pause

%log% .
%log% [%time%]
%log% [1/7] Stoppe Windows Update-Dienste...
net stop wuauserv >> "%~dp0update_log.txt"
timeout /t 2 >nul

%log% .
%log% [%time%]
%log% [2/7] Stoppe Cryptographic Services...
net stop cryptSvc >> "%~dp0update_log.txt"
timeout /t 2 >nul

%log% .
%log% [%time%]
%log% [3/7] Stoppe Background Intelligent Transfer Service...
net stop bits >> "%~dp0update_log.txt"
timeout /t 2 >nul

%log% .
%log% [%time%]
%log% [4/7] Stoppe Windows Installer-Dienst...
net stop msiserver >> "%~dp0update_log.txt"
timeout /t 2 >nul

:software_dist_choice
%log% .
%log% [%time%]
%log% [5/7] Update-Ordner bereinigen...
%log% Soll der Ordner "SoftwareDistribution" umbenannt oder gelöscht werden?
%log% [U] Umbenennen nach "SoftwareDistribution.old"
%log% [L] Löschen des Inhalts (behält leeren Ordner)
%log% [N] Nichts tun (überspringen)
set /p choice="Wählen Sie (U/L/N): "
echo Wählen Sie (U/L/N): !choice! >> "%~dp0update_log.txt"

if /i "!choice!"=="U" (
    if exist "C:\Windows\SoftwareDistribution" (
        ren "C:\Windows\SoftwareDistribution" "SoftwareDistribution.old" >> "%~dp0update_log.txt"
        %log%   -> "SoftwareDistribution" wurde in "SoftwareDistribution.old" umbenannt.
    ) else (
        %log%   -> "SoftwareDistribution" existiert nicht.
    )
) else if /i "!choice!"=="L" (
    if exist "C:\Windows\SoftwareDistribution" (
	del /s /q /f "%windir%\SoftwareDistribution\*.*" >> "%~dp0update_log.txt"
        %log%   -> Inhalt von "SoftwareDistribution" wurde gelöscht.
    ) else (
        %log%   -> "SoftwareDistribution" existiert nicht.
    )
) else if /i "!choice!"=="N" (
    %log%   -> "SoftwareDistribution" wird nicht verändert.
) else (
    %log% Ungültige Eingabe! Bitte "U", "L" oder "N" wählen.
    goto :software_dist_choice
)
timeout /t 2 >nul

%log% .
%log% [%time%]
%log% [6/7] Benenne Catroot2-Ordner um...
if exist "C:\Windows\System32\catroot2" (
    ren "C:\Windows\System32\catroot2" "catroot2.old" >> "%~dp0update_log.txt"
    %log%   -> "catroot2" wurde in "catroot2.old" umbenannt.
) else (
    %log%   -> "catroot2" existiert nicht.
)
timeout /t 2 >nul

%log% .
%log% [%time%]
%log% [7/7] Starte Dienste neu...
net start wuauserv >> "%~dp0update_log.txt"
timeout /t 2 >nul
net start cryptSvc >> "%~dp0update_log.txt"
timeout /t 2 >nul
net start bits >> "%~dp0update_log.txt"
timeout /t 2 >nul
net start msiserver >> "%~dp0update_log.txt"
timeout /t 2 >nul

%log% .
%log% Fertig! Windows Update-Komponenten wurden zurückgesetzt.
%log% .

:restart_prompt
set /p restart="Möchten Sie den PC jetzt neu starten? (J/N): "
echo Möchten Sie den PC jetzt neu starten? (J/N): !restart! >> "%~dp0update_log.txt"
if /i "!restart!"=="J" (
    %log% PC wird neu gestartet...
    shutdown /r /t 30 /c "Das System wird aufgrund des Windows Update Resets neu gestartet"
) else if /i "!restart!"=="N" (
    %log% PC wird nicht neu gestartet. Das Fenster wird in 4 Skunden geschlossen.
    timeout /t 4 >nul
) else (
    %log% Ungültige Eingabe. Bitte "J" oder "N" eingeben.
    goto :restart_prompt
)

endlocal
exit /b